//
//  calcPerfClass.h
//  H135
//
//  Created by Claus Richter on 10/29/17.
//
//

#import <UIKit/UIKit.h>

@interface calcPerfClass : UIViewController {
    
    CAShapeLayer *circleLayer;
    UIBezierPath *pathC;
    
    NSString *specialChart;
    NSString *fixedWingSetupText;
    NSArray *arrayFixedWingSetup;
    
    NSString *nameVariSlider1, *nameVariSlider2, *nameVariSlider3, *nameVariSlider4, *foundCATEnvelopeName;
    
    float OEIMCPGrad3000; // 2000 ft ISA
    float OEIMCPGrad4000; // 3000 ft ISA
    float OEIMCPGrad5000; // 4000 ft ISA
    
    float AS365N3minWeight1, AS365N3minWeight2, resultTorquePercent, resultTOT;
    
    float resultTOGroundRoll, resultTO50ft, resultLDGGroundRoll, resultLDG50ft;
    
    UIView *viewCross1;    
    UIView *viewCross2;
    UIView *viewCross3;
    UIView *viewCross4;
    UIView *viewCross5;

    int flagCustomPageIsOn;
    
    int totalCeilingSteps1;
    int totalCeilingSteps2;
    int totalCeilingSteps3;
    int totalCeilingSteps4;
    int totalCeilingStepsOLD;
    NSString *computationErrorMessage;
    NSString *computationErrorDisplay;
    
    int flagGettingFuelFromInputField, flagYandXinputSpecialChart, flagFindEnvelopeFromYandX, flagAWHVdiagram;
    
    int flagPC2Warning;
    NSString *PC2warningString;
    
    // calc performance
    float ceilingInputYAxis, ceilingInputCurve;
    
    NSMutableArray *resultsAllChartNames;
    NSMutableArray *resultsAllChartUserNames;
    NSMutableArray *resultsAllChartValues;
    NSMutableArray *resultsAllUnits;
    NSMutableArray *resultsAllDataOutOfRange;
    NSMutableArray *resultsAllPrintOnManifest;
    NSMutableArray *resultsAllEnviSettings;
    NSMutableArray *resultsAllMargins;
    
    NSString *arrayKey;
    
    NSString *serverUrl;
    NSString *ACCategory;
    NSString *ACmanufacturer;
    NSString *AC_Type;
    NSString *ACVariant;
    
    NSArray *chartsArray;
    
 
    int numberOfChartsForThisAircraft;
    
    int actualButtonNumber, actualChartNumber;
    
    int flagDrawACweightLines, flagWeHaveAS365PC2computation, flagPC2dataOutOfRange;
    
    float PC2valCATAMTOW, exposureTime, exposureTimeLD;
    NSString *resultText;
    
    int nChart;
    
    NSArray *infoArray;
    
    float weightTOW;
    
    int chartNumberForResult;
    
    float selectedChartButton, fullScreenPerfCharts;
    
    NSString *chartNameForThisInfoFile;
    
    NSString *chartNameToLoad;
    
    NSString *chartNameForCriteria;
    
    NSString *chartNameForSliderDefaults;
    
    NSMutableArray *arrayPowerSets;
    
    
    // get getInfoForCurrentChart
    
    float cruiseSegmentSelected;
    
    int  numberOfComputationParts, flagUbertragClimb, triggerCruiseSegmentSet, CruiseMaxElevation, CruiseElevationincrement, CruiseMaxDistance;
    
    float  flagClimbPageIsOpen, flagTOPageIsOpen, Climb_EndPressureAlt, Climb_EndOAT, Climb_EndISADiff, Climb_EndElevation, Climb_EndAltimeter, Climb_FuelTotal, flagCruisePageIsOpen,  flagLandingPageIsOpen;
    
    float TO_PA, flapSettingTO, flapSettingLD;
    float Climb_OAT, Climb_ELEV, Climb_ALTIM, Climb_ISADIFF;
    float LDG_OAT, LDG_ELEV, LDG_ALTIM, LDG_ISADIFF;
    float Cruise_OAT, Cruise_ELEV, Cruise_ALTIM, Cruise_ISADIFF, maxClimbDistanceForGraph, maxClimbDistanceSteps;
    
    //r44
    float maxContinuousPower, fiveMinuteTakeoffPower, vPA, redCrossYValue, CUT, maxContinuousPowerResult, fiveMinuteTakeoffPowerResult, VNE, VNEinterpolTotal;
    
    float  warningThreshold;
    NSString *chartAdditionalInfo;
    NSString *envirnomentAdditionalInfo;
    NSString *enviSliderSetForTakeoff;
    NSString *enviSliderSetForLanding;
    

    
    NSString *chartUserName;    
    NSString *limitationsForHoist;
    
       
    // loopAllPartsAndSaveResults
    
    int partNumberToCompute;
    
    int infoPartNumber;
    
    int flagThisPartResultContainsTransferValue;
    
    float factorForResult;
    
    float resultComputation;
    
    NSMutableDictionary *transferValueDictionary;
    
    NSString *unitResult;
    
    NSString *ACweightUnitsUsed;
       
  
    
    float resultFromComputations;
    
    NSString *chartNameForComputation;
    NSString *userNameForComputation;
    NSString *unitNameForComputation;
    
    UILabel *dL;
    
    // drawCrossesAndLines
    
    int nCross;
    
    int newWPDdataAvialable;
    
    NSMutableArray *infoPartArray;
    
    float xPix1, xPix2, xPix3, yPix1, yPix2, yPix3;
    
    float chartWidthPixel, chartHeightPixel;
    
    float xLeftChart, yBottomChart, xRightChart, yTopChart, xLeftGC, yBottomGC, xRightGC, yTopGC;
    
    float chartWidthInApp, chartHeightInApp, xposition, yposition, Xinput, Yinput;
    
    float cross1ValueX, cross1ValueY, cross2ValueX, cross2ValueY, cross3ValueX, cross3ValueY, cross4ValueX, cross4ValueY, cross5ValueX, cross5ValueY;
    
    
    
    // draw line
    
    NSString *crossLineSequence;
    
    int yToX;
    
    float minInput, maxInput, lineBaseLeftX,lineBaseRightX,  minResult, maxResult, lineBaseBottomY, lineBaseTopY;
    
    UIBezierPath *pathLine;
    
    float drawToFixedPointX, drawToFixedPointY;
    
    float markerPointX1;
    
    int flagOATisXaxis;
    
    
    // computeChartSizeInApp
    
    float flagChartsFitToScreenHeight;
    
    float pinchScale, moveLeftRight, moveupDown, pinchScaleEnded;
    
    
    // loadChartImage
    
    NSString *previousChartName;
    
  
    
    
    
    
    // getInfoFileForThisPart
    
    float minCurve, maxCurve, maxResultWithRestriction;    
    
  
    
    
    
    // getInputForCurveAndAxis
    
    float givenCurveInputValue;   
    
    float OAT, Hp, acWeight, acLandingWeight, headWindKTS, unchangedACWeight, fuelWeight, DensityAlt, IAS, RATINGINDEX, PROPRPM;
    
    
    float givenAxisInputValue;
    
    
    // checkInputDataRange
    
    int flagInputDataOutOfRange;
    
    
    // calcComputation
    
    NSArray *availableCurvesArray;
    
    
    // limitResultValues
    
    int flagOutputDataOutOfRange;
    
    
    
    NSData *chartImageData; //saved as signatureImage
    
    UIImage *chartImageFile; //
    
    
    NSMutableDictionary *chartImagesDictionary;
    
    
    
    float ISADiff, QNH_USA;
    float altimeterInches;
    
    int flagCeilingComputation;
    
    float statusOverride;
    
    float interpolationResult;
    
    float penaltyWeight;
    float penaltyFtMin;
    
    
    float TDPheight;
    float RearwardTODist;
    float MinHeight;
    float HeightAchievedVTOSS;
    float contTODist, climbPressureAltUsed;
    
    NSString *powerCheckType;
    NSString *takeoffSliderSettings;  
    NSString *climbSliderSettings; 
    NSString *landingSliderSettings;
    NSString *cruiseSliderSettings; 
    
    NSString *selectedUnitsForItems;
    NSString *originalPerformanceDistanceUnits;
    NSString *originalPerformanceWeightUnits;
    NSString *compString;
    
    float OAT_TO, PA_TO, Wind_TO;
    float OAT_Climb, PA_Climb, Wind_Climb;
    float OAT_LD, PA_LD, Wind_LD;
    float OAT_Cruise, PA_Cruise, Wind_Cruise;
    
    float conversionFeetToMeter, conversionNNMtoKM, incrementRunwayLength, initialRunwayFrameWidth, totalTripRange, cruiseRangeWindowNM, previousCruiseRangeWindowNM;

    
    int flagEnviNeedsOverride, triggerLoadSliderData, triggerPerformanceOutOfRange, triggerCruiseRangeWarning;
    
    
    float originalGroundRoll, penaltyWindGR, penaltyRunwayConditionsGR, penaltySlopeGR, totalGroundRoll;
    float originalDistance50ft, penaltyWind50ft, penaltyRunwayConditions50ft, penaltySlope50ft, totalDistance50ft, resultClimbDistanceTotal;
    
    float  frwyIncrement, climbXaxisEnd, climbYaxisEnd, climbDistanceEnd, climbDistanceStart, maxPAforThisComputation, minPAforThisComputation, previousmMaxPAforThisComputation;  
    float  cruiseXaxisEnd, cruiseYaxisEnd, cruiseDistanceEnd;
    
    float subtractInches, MAPResult, sliderEngineRPMincrement;
    NSString *unitDistance, *unitDistanceNMkm;
    
    
}

- (void) loadFixedWingSliders;
- (void) saveFixedWingSliders;

extern float resultGroundRoll, engineRPMcruise, resultWindDifferenceGR_TO, resultWindDifference50ft_TO, resultWindDifferenceGR_LD, resultWindDifference50ft_LD;
extern float resultDistanceOverObstacle, resultClimbSpeed, resultClimbTime, resultClimbFuel, resultClimbDistance, resultClimbRoC, resultCruiseKTAS, resultCruiseFuelBurn, resultCruiseBHP, resultRPMmin, resultRPMmax  ;
extern NSString *currentACtype;


- (void) transferMethod:  (float)receivedOAT  sendPA:(float)receivedPA  sendAltimeterUSA:(float)receivedAltimeterUSA sendHeadWindKts:(float)receivedHeadWindKts sendACweight:(float)receivedACweight sendACLandingweight:(float)receivedACLandingweight sendSelectedChartButton:(float)receivedSelectedChartButton   sendISADiff:(float)receivedISADiff   sendAltimeterInches:(float)receivedAltimeterInches sendPenaltyWeight:(float)receivedPenaltyWeight sendPenaltyFtMin:(float)receivedPenaltyFtMin sendFuelWeight:(float)receivedFuelWeight sendDA:(float)receivedDA sendACWeightUnit:(NSString*)receivedACWeightUnit sendIAS:(float)receivedIAS sendRatingIndex:(float)receivedRatingIndex sendPROPRPM:(float)receivedPROPRPM sendselectedUnitForItems:(NSString*)receivedSelectedUnitsForItems;

- (void) resetInputObstacleHeight;

- (void) triggerLoadSliderData;



- (void) triggerPresetSliders;

//- (void) interpolationMethod: (float)receivedBaseValue lowVal:(float)receivedLowVal highVal:(float)receivedHighVal lowSearch:(float)receivedLowSearch highSearch:(float)receivedHighSearch;


@property (strong, nonatomic) IBOutlet UIView *viewUniversalButtons;


// drawCrossesAndLines


@property (strong, nonatomic) IBOutlet UIView *viewLinesOnChart;

@property (strong, nonatomic) IBOutlet UIImageView *universalChartGraphic;


// computeChartSizeInApp

@property (strong, nonatomic) IBOutlet UIView *masterViewCharts;

@property (strong, nonatomic) IBOutlet UIView *viewChartContainer;

@property (strong, nonatomic) IBOutlet UIView *viewChartsUniversal;

@property (strong, nonatomic) IBOutlet UIView *viewPowerCheck;

@property (strong, nonatomic) IBOutlet UIView *viewPowerCheck2;

@property (strong, nonatomic) IBOutlet UIView *viewTakeoff;
@property (strong, nonatomic) IBOutlet UIView *viewClimb;
@property (strong, nonatomic) IBOutlet UIView *viewCruise;
@property (strong, nonatomic) IBOutlet UIView *viewGlide;
@property (strong, nonatomic) IBOutlet UIView *viewLanding;
@property (strong, nonatomic) IBOutlet UIView *viewR44Manifold;
@property (strong, nonatomic) IBOutlet UIView *viewR44VNE;

@property (strong, nonatomic) IBOutlet UIView *viewSummary;



- (void) resetPreviousChartName;


@property (strong, nonatomic) IBOutlet UIView *viewCATAOverview1;

@property (strong, nonatomic) IBOutlet UIView *viewCATAOverview2;

@property (strong, nonatomic) IBOutlet UIView *viewCATAOverview3;

@property (strong, nonatomic) IBOutlet UIView *viewPC2OverviewAS365;


@property (strong, nonatomic) IBOutlet UILabel *labelCurrentACweight;


@property (strong, nonatomic) IBOutlet UILabel *labelFuelWeight;

@property (strong, nonatomic) IBOutlet UILabel *labelDensityAlt;



@property (strong, nonatomic) IBOutlet UILabel *interpolatedSeg1OEIMCPGrad;
@property (strong, nonatomic) IBOutlet UILabel *interpolatedSeg2OEIMCPGrad;;


@property (strong, nonatomic) IBOutlet UILabel *interpolatedSeg2ORIMCPGrad3000;
@property (strong, nonatomic) IBOutlet UILabel *interpolatedSeg2ORIMCPGrad4000;
@property (strong, nonatomic) IBOutlet UILabel *interpolatedSeg2ORIMCPGrad5000;


@property (strong, nonatomic) IBOutlet UILabel *addGain2Vy;

@property (strong, nonatomic) IBOutlet UILabel *catAEnRouteOEIMCPCeiling;


@property (strong, nonatomic) IBOutlet UILabel *MTOWcorrectionPenalty;

@property (strong, nonatomic) IBOutlet UILabel *MTOWcorrected;


@property (strong, nonatomic) IBOutlet UILabel *chMaxMass;

@property (strong, nonatomic) IBOutlet UILabel *chRejectedTOdist;

@property (strong, nonatomic) IBOutlet UILabel *chContTOdist;

@property (strong, nonatomic) IBOutlet UILabel *chAccelDist;

@property (strong, nonatomic) IBOutlet UILabel *chLandingDist;

@property (strong, nonatomic) IBOutlet UILabel *chMaxMassCeiling;



@property (strong, nonatomic) IBOutlet UILabel *AEOHIGETOP;
@property (strong, nonatomic) IBOutlet UILabel *AEOHOGETOP;
@property (strong, nonatomic) IBOutlet UILabel *AEOHIGE2min;
@property (strong, nonatomic) IBOutlet UILabel *AEOHOGE2min;
@property (strong, nonatomic) IBOutlet UILabel *AEOHOGE30sec;


- (IBAction)actionSwitchCATAVTOL:(id)sender;


@property (strong, nonatomic) IBOutlet UIView *viewCATACH;

@property (strong, nonatomic) IBOutlet UIView *viewVTOL;

@property (strong, nonatomic) IBOutlet UILabel *VTOLMaxMass;
@property (strong, nonatomic) IBOutlet UILabel *VTOLMaxMassCeiling;

@property (strong, nonatomic) IBOutlet UILabel *VTOLAccelerationDistance;
@property (strong, nonatomic) IBOutlet UILabel *VTOLMaxMassTraining;


@property (strong, nonatomic) IBOutlet UITextField *inputObstacleHeightMeter;


@property (strong, nonatomic) IBOutlet UILabel *labelMinHeight;

@property (strong, nonatomic) IBOutlet UILabel *labelTDPHeight;

@property (strong, nonatomic) IBOutlet UILabel *labelRearwardTODist;

@property (strong, nonatomic) IBOutlet UILabel *labelHeightAchieved;

@property (strong, nonatomic) IBOutlet UILabel *labelContinuedTODist;


- (IBAction)closeKeyboard:(id)sender;



// power check ***********

// Engine 2

- (IBAction)closeKeyboardPowerCheck:(id)sender;

- (IBAction)closeKeyboardCruise:(id)sender;

@property (strong, nonatomic) IBOutlet UISlider *sliderEngineTorque1;

- (IBAction)sliderActionEngineTorque1:(id)sender;
@property (strong, nonatomic) IBOutlet UITextField *inputEngineTorque1;

@property (strong, nonatomic) IBOutlet UISlider *sliderITT1;

- (IBAction)sliderActionITT1:(id)sender;


@property (strong, nonatomic) IBOutlet UITextField *inputITT1;

@property (strong, nonatomic) IBOutlet UILabel *labelMaxAllowableITTEngine1;

@property (strong, nonatomic) IBOutlet UILabel *labelPowerCheckResult1;

@property (strong, nonatomic) IBOutlet UILabel *labelMargineEngine1;

// Engine 2

@property (strong, nonatomic) IBOutlet UISlider *sliderITT2;

- (IBAction)sliderActionITT2:(id)sender;


@property (strong, nonatomic) IBOutlet UISlider *sliderEngineTorque2;

- (IBAction)sliderActionEngineTorque2:(id)sender;

@property (strong, nonatomic) IBOutlet UITextField *inputEngineTorque2;


@property (strong, nonatomic) IBOutlet UITextField *inputITT2;

@property (strong, nonatomic) IBOutlet UILabel *labelMaxAllowableITTEngine2;

@property (strong, nonatomic) IBOutlet UILabel *labelPowerCheckResult2;

@property (strong, nonatomic) IBOutlet UILabel *labelMargineEngine2;



@property (strong, nonatomic) IBOutlet UISegmentedControl *segentCheckType;
- (IBAction)actionSegmentCheckType:(id)sender;

- (IBAction)actionSendPowerCheckViaEmail:(id)sender;


@property (strong, nonatomic) IBOutlet UIImageView *symRunway;

@property (strong, nonatomic) IBOutlet UIImageView *symAC0;
@property (strong, nonatomic) IBOutlet UIImageView *symAC1;
@property (strong, nonatomic) IBOutlet UIImageView *symAC2;
@property (strong, nonatomic) IBOutlet UIImageView *symObstacle;

@property (strong, nonatomic) IBOutlet UIImageView *symWindCircle;
@property (strong, nonatomic) IBOutlet UIView *viewWindCircle;

@property (strong, nonatomic) IBOutlet UISlider *sliderRundwayHeadingTO;
- (IBAction)sliderActionRunwayHeadingTO:(id)sender;
@property (strong, nonatomic) IBOutlet UILabel *labelSliderRunwayHeadingTO;

- (IBAction)sliderActionRunwayLength:(id)sender;


@property (strong, nonatomic) IBOutlet UIImageView *symACClimb1;
@property (strong, nonatomic) IBOutlet UIImageView *symACClimb2;



@property (strong, nonatomic) IBOutlet UILabel *labelRunwayLength;

@property (strong, nonatomic) IBOutlet UISlider *sliderRunwayLength;

@property (strong, nonatomic) IBOutlet UISegmentedControl *segmentMeterFeet;

- (IBAction)segmentActionFixedWingDistanceUnitsTO:(id)sender;
- (IBAction)segmentActionFixedWingDistanceUnitsClimb:(id)sender;

- (IBAction)segmentActionFixedWingDistanceUnitsLD:(id)sender;



// ------ LANDING

@property (strong, nonatomic) IBOutlet UIImageView *symRunwayLD;


@property (strong, nonatomic) IBOutlet UIImageView *symAC0LD;

@property (strong, nonatomic) IBOutlet UIImageView *symAC1LD;

@property (strong, nonatomic) IBOutlet UIImageView *symAC2LD;

@property (strong, nonatomic) IBOutlet UIImageView *symObstacleLD;

@property (strong, nonatomic) IBOutlet UIImageView *symWindCircleLD;

@property (strong, nonatomic) IBOutlet UIView *viewWindCircleLD;



- (IBAction)sliderActionRunwayLengthLD:(id)sender;
@property (strong, nonatomic) IBOutlet UISlider *sliderRunwayLengthLD;



@property (strong, nonatomic) IBOutlet UILabel *labelRunwayLengthLD;


@property (strong, nonatomic) IBOutlet UISegmentedControl *segmentMeterFeetLD;
@property (strong, nonatomic) IBOutlet UISegmentedControl *segmentMeterFeetClimb;

@property (strong, nonatomic) IBOutlet UILabel *labelOverObstacle;

@property (strong, nonatomic) IBOutlet UILabel *labelGroundRoll;

@property (strong, nonatomic) IBOutlet UILabel *labelLandingDistanceToTouchDown;

@property (strong, nonatomic) IBOutlet UILabel *labelLandingDistanceToStop;

@property (strong, nonatomic) IBOutlet UISlider *sliderAircraftWeightOverrideTO;

- (IBAction)sliderActionACWeightOverrideTO:(id)sender;

@property (strong, nonatomic) IBOutlet UILabel *labelSliderACWeightOverrideTO;

@property (strong, nonatomic) IBOutlet UISlider *sliderRunwayConditionsTO;
- (IBAction)sliderActionRunwayConditionsTO:(id)sender;
@property (strong, nonatomic) IBOutlet UILabel *labelSliderARunwayConditionsTO;


@property (strong, nonatomic) IBOutlet UISlider *sliderSlopeTO;
- (IBAction)sliderActionSlopeTO:(id)sender;
@property (strong, nonatomic) IBOutlet UILabel *labelSliderSlopeTO;






@property (strong, nonatomic) IBOutlet UISlider *sliderAircraftWeightOverrideLD;
- (IBAction)sliderActionACWeightOverrideLD:(id)sender;

@property (strong, nonatomic) IBOutlet UILabel *labelSliderACWeightOverrideLD;



@property (strong, nonatomic) IBOutlet UILabel *labelHeadwindComponentTO;

@property (strong, nonatomic) IBOutlet UILabel *labelConditionsTO;
@property (strong, nonatomic) IBOutlet UILabel *labelConditionsLD;

@property (strong, nonatomic) IBOutlet UIImageView *runwayTopViewTO;
@property (strong, nonatomic) IBOutlet UIImageView *windsockTO;
@property (strong, nonatomic) IBOutlet UIImageView *windsockRwyTO;

@property (strong, nonatomic) IBOutlet UIView *viewTORunway;


@property (strong, nonatomic) IBOutlet UILabel *iGroundRoll;
@property (strong, nonatomic) IBOutlet UILabel *iWind;
@property (strong, nonatomic) IBOutlet UILabel *iConditions;
@property (strong, nonatomic) IBOutlet UILabel *iSlope;
@property (strong, nonatomic) IBOutlet UILabel *iTotalGroundRoll;

@property (strong, nonatomic) IBOutlet UILabel *iDistance50ft;
@property (strong, nonatomic) IBOutlet UILabel *iWind50ft;
@property (strong, nonatomic) IBOutlet UILabel *iConditions50ft;
@property (strong, nonatomic) IBOutlet UILabel *iSlope50ft;
@property (strong, nonatomic) IBOutlet UILabel *iTotalDistance50ft;

@property (strong, nonatomic) IBOutlet UILabel *labelWindTypeTO;
@property (strong, nonatomic) IBOutlet UIView *viewRunwayMarksTO;


- (IBAction)actionLockACweightOverrideTO:(id)sender;
@property (strong, nonatomic) IBOutlet UIImageView *lockACweightTO;


// climb

@property (strong, nonatomic) IBOutlet UILabel *labelConditionsClimb;

@property (strong, nonatomic) IBOutlet UISlider *sliderClimbEnd;

@property (strong, nonatomic) IBOutlet UILabel *labelHeadWindClimb;
@property (strong, nonatomic) IBOutlet UILabel *labelWindTypeClimb;

@property (strong, nonatomic) IBOutlet UIView *viewForClimbGrid;
@property (strong, nonatomic) IBOutlet UIView *viewForClimbAnimations;




// landing

@property (strong, nonatomic) IBOutlet UILabel *labelHeadwindComponentLD;

@property (strong, nonatomic) IBOutlet UIImageView *runwayTopViewLD;
@property (strong, nonatomic) IBOutlet UIImageView *windsockLD;

@property (strong, nonatomic) IBOutlet UIView *viewLDRunway;

@property (strong, nonatomic) IBOutlet UILabel *iGroundRollLD;
@property (strong, nonatomic) IBOutlet UILabel *iWindLD;
@property (strong, nonatomic) IBOutlet UILabel *iConditionsLD;
@property (strong, nonatomic) IBOutlet UILabel *iSlopeLD;
@property (strong, nonatomic) IBOutlet UILabel *iTotalGroundRollLD;

@property (strong, nonatomic) IBOutlet UILabel *iDistance50ftLD;
@property (strong, nonatomic) IBOutlet UILabel *iWind50ftLD;
@property (strong, nonatomic) IBOutlet UILabel *iConditions50ftLD;
@property (strong, nonatomic) IBOutlet UILabel *iSlope50ftLD;
@property (strong, nonatomic) IBOutlet UILabel *iTotalDistance50ftLD;

@property (strong, nonatomic) IBOutlet UILabel *labelWindTypeLD;
@property (strong, nonatomic) IBOutlet UIView *viewRunwayMarksLD;

- (IBAction)actionLockACweightOverrideLD:(id)sender;
@property (strong, nonatomic) IBOutlet UIImageView *lockACweightLD;

@property (strong, nonatomic) IBOutlet UISlider *sliderRundwayHeadingLD;
- (IBAction)sliderActionRunwayHeadingLD:(id)sender;
@property (strong, nonatomic) IBOutlet UILabel *labelSliderRunwayHeadingLD;

@property (strong, nonatomic) IBOutlet UISlider *sliderRunwayConditionsLD;
- (IBAction)sliderActionRunwayConditionsLD:(id)sender;
@property (strong, nonatomic) IBOutlet UILabel *labelSliderARunwayConditionsLD;


@property (strong, nonatomic) IBOutlet UISlider *sliderSlopeLD;
- (IBAction)sliderActionSlopeLD:(id)sender;
@property (strong, nonatomic) IBOutlet UILabel *labelSliderSlopeLD;

@property (strong, nonatomic) IBOutlet UIView *viewLandingWeightOverride;




@property (strong, nonatomic) IBOutlet UILabel *PC2labelISARange;
@property (strong, nonatomic) IBOutlet UILabel *PC2labelCATAMTOW;
@property (strong, nonatomic) IBOutlet UILabel *PC2labelExposureTime1;
@property (strong, nonatomic) IBOutlet UILabel *PC2labelExposureTimeWind;
@property (strong, nonatomic) IBOutlet UILabel *PC2labelExposureTimePA;
@property (strong, nonatomic) IBOutlet UILabel *PC2labelExposureTimeISA;
@property (strong, nonatomic) IBOutlet UILabel *PC2labelTTET;
@property (strong, nonatomic) IBOutlet UILabel *PC2labelActualTOW;


@property (strong, nonatomic) IBOutlet UILabel *PC2labelISARangeLD;
@property (strong, nonatomic) IBOutlet UILabel *PC2labelCATAMTOWLD;
@property (strong, nonatomic) IBOutlet UILabel *PC2labelExposureTime1LD;
@property (strong, nonatomic) IBOutlet UILabel *PC2labelExposureTimeWindLD;
@property (strong, nonatomic) IBOutlet UILabel *PC2labelExposureTimePALD;
@property (strong, nonatomic) IBOutlet UILabel *PC2labelExposureTimeISALD;
@property (strong, nonatomic) IBOutlet UILabel *PC2labelTTETLD;
@property (strong, nonatomic) IBOutlet UILabel *PC2labelActualTOWLD;

@property (strong, nonatomic) IBOutlet UILabel *PC2labelVLSS;


@property (strong, nonatomic) IBOutlet UILabel *iClimbTimeStart;
@property (strong, nonatomic) IBOutlet UILabel *iClimbFuelStart;
@property (strong, nonatomic) IBOutlet UILabel *iClimbDistanceStart;
@property (strong, nonatomic) IBOutlet UILabel *iClimbPAStart;
@property (strong, nonatomic) IBOutlet UILabel *iClimbSpeedStart;
@property (strong, nonatomic) IBOutlet UILabel *iClimbRoCdStart;

@property (strong, nonatomic) IBOutlet UILabel *iClimbTimeEnd;
@property (strong, nonatomic) IBOutlet UILabel *iClimbFuelEndt;
@property (strong, nonatomic) IBOutlet UILabel *iClimbDistanceEnd;
@property (strong, nonatomic) IBOutlet UILabel *iClimbPAEnd;
@property (strong, nonatomic) IBOutlet UILabel *iClimbSpeedEnd;
@property (strong, nonatomic) IBOutlet UILabel *iClimbRoCdEnd;

@property (strong, nonatomic) IBOutlet UILabel *iClimbTimeTotal;
@property (strong, nonatomic) IBOutlet UILabel *iClimbFuelTotal;
@property (strong, nonatomic) IBOutlet UILabel *iClimbDistanceTotal;
@property (strong, nonatomic) IBOutlet UILabel *iCessna172ISATempCorrection;


@property (strong, nonatomic) IBOutlet UIView *viewCruiseGrid;
@property (strong, nonatomic) IBOutlet UIView *viewCruiseAnimations;

@property (strong, nonatomic) IBOutlet UISegmentedControl *segmentMeterFeetCruise;

- (IBAction)segmentActionFixedWingDistanceUnitsCruise:(id)sender;

// cruise

@property (strong, nonatomic) IBOutlet UISlider *sliderEngineRPMcruise;
- (IBAction)sliderActionEngineRPMcruise:(id)sender;
@property (strong, nonatomic) IBOutlet UILabel *labelEngineRPMcruise;

@property (strong, nonatomic) IBOutlet UILabel *iCruiseSpeed;

@property (strong, nonatomic) IBOutlet UILabel *iCruiseFuelBurn;
@property (strong, nonatomic) IBOutlet UILabel *iCruiseBHP;
@property (strong, nonatomic) IBOutlet UILabel *iCruiseGroundSpeed;
@property (strong, nonatomic) IBOutlet UILabel *iCruisePressureAlt;
@property (strong, nonatomic) IBOutlet UILabel *iCruiseTripFuel;
@property (strong, nonatomic) IBOutlet UILabel *iCruiseConditions;
@property (strong, nonatomic) IBOutlet UILabel *iCruiseTime;
@property (strong, nonatomic) IBOutlet UILabel *iCruiseDistance;
@property (strong, nonatomic) IBOutlet UILabel *iCruiseToD;

@property (strong, nonatomic) IBOutlet UILabel *labelCruiseRPMmin;
@property (strong, nonatomic) IBOutlet UILabel *labelCruiseRPMmax;

@property (strong, nonatomic) IBOutlet UISlider *sliderTripDistanceNM;
- (IBAction)sliderActionTripDistanceNM:(id)sender;

@property (strong, nonatomic) IBOutlet UILabel *labelTripDistanceNM;

// cruise

@property (strong, nonatomic) IBOutlet UILabel *labelWindComponentCruise;
@property (strong, nonatomic) IBOutlet UILabel *labelWindSpeedCruise;


@property (strong, nonatomic) IBOutlet UILabel *iTripClimbDistance;

@property (strong, nonatomic) IBOutlet UILabel *iTripDescentDistance;
@property (strong, nonatomic) IBOutlet UILabel *iTripTotalDistance;

@property (strong, nonatomic) IBOutlet UILabel *iDescentRoD;
@property (strong, nonatomic) IBOutlet UILabel *iDescentGroundSpeed;

@property (strong, nonatomic) IBOutlet UILabel *iDescentTAS;
@property (strong, nonatomic) IBOutlet UILabel *iDescentFuelFlow;
@property (strong, nonatomic) IBOutlet UILabel *iDescentTime;

@property (strong, nonatomic) IBOutlet UIImageView *symACCruise;

@property (strong, nonatomic) IBOutlet UIView *warningTripFuel;

@property (strong, nonatomic) IBOutlet UIView *viewSliderEngineRPM;
@property (strong, nonatomic) IBOutlet UIView *viewCruiseOverride;
@property (strong, nonatomic) IBOutlet UITextField *cruiseInputTAS;
@property (strong, nonatomic) IBOutlet UITextField *cruiseInputFuelFlow;
@property (strong, nonatomic) IBOutlet UIView *viewCruisePowerSegment;


//R44
@property (strong, nonatomic) IBOutlet UIView *viewR44ManifoldChart;
@property (weak, nonatomic) IBOutlet UIImageView *barMCPVerticalBlue;
@property (weak, nonatomic) IBOutlet UIImageView *barMCPVerticalRED;
@property (weak, nonatomic) IBOutlet UIImageView *barQuerRed;
@property (weak, nonatomic) IBOutlet UIImageView *barQuerBlue;
@property (weak, nonatomic) IBOutlet UILabel *labelMinusInches;
@property (weak, nonatomic) IBOutlet UIImageView *crossMCP;
@property (weak, nonatomic) IBOutlet UIImageView *crossMCP2;
@property (weak, nonatomic) IBOutlet UILabel *labelMCP;
@property (weak, nonatomic) IBOutlet UILabel *labelMAPmax;
@property (weak, nonatomic) IBOutlet UIImageView *graphicMAPneedle;
@property (strong, nonatomic) IBOutlet UILabel *labelRobinsonMinusInches;


//VNE
@property (weak, nonatomic) IBOutlet UIImageView *graphicAirspeedPointer;
@property (strong, nonatomic) IBOutlet UILabel *labelIASWarning;

@property (strong, nonatomic) IBOutlet UIImageView *graphicRobinsonMAPinstrument;
@property (strong, nonatomic) IBOutlet UIImageView *graphicRobinsonMAPchart;

@property (strong, nonatomic) IBOutlet UIImageView *graphicRobinsonVNEchart;
@property (strong, nonatomic) IBOutlet UISwitch *robinsonSwitchCarbHeat;
- (IBAction)robinsonActionSwitchCarbHeat:(id)sender;
@property (strong, nonatomic) IBOutlet UIView *robinsonViewCarbHeat;
@property (strong, nonatomic) IBOutlet UILabel *robinsonLabelCarbHeat;

@property (strong, nonatomic) IBOutlet UISegmentedControl *segmentCruisePower;
- (IBAction)actionSegmentCruisePower:(id)sender;

@property (strong, nonatomic) IBOutlet UISwitch *switchOverrideCruiseInput;
- (IBAction)actionSwitchOverrideCruiseInput:(id)sender;


@property (strong, nonatomic) IBOutlet UISegmentedControl *segmentFlapsLD;

- (IBAction)segmentActionFlapsLD:(id)sender;

@property (strong, nonatomic) IBOutlet UILabel *labelClimbTempCorrectionInfo;


@property (strong, nonatomic) IBOutlet UIView *viewCruiseDescentInfo;

@property (strong, nonatomic) IBOutlet UIView *viewCruiseTripInfo;
@property (strong, nonatomic) IBOutlet UILabel *labelFuelFlowCruisePage;

@property (strong, nonatomic) IBOutlet UILabel *iTripClimbFuel;
@property (strong, nonatomic) IBOutlet UILabel *iTripCruiseFuel;

@property (strong, nonatomic) IBOutlet UILabel *iTripDescentFuel;

@property (strong, nonatomic) IBOutlet UILabel *iTripTotalFuel;

@property (strong, nonatomic) IBOutlet UILabel *labelUsableFuelOnBoard;


@property (strong, nonatomic) IBOutlet UILabel *labelLandingFuelOnCruise;

@property (strong, nonatomic) IBOutlet UILabel *labelReserveTimeOnCruise;

@property (strong, nonatomic) IBOutlet UILabel *labelWarningTripFuel;
@property (strong, nonatomic) IBOutlet UIImageView *robinsonAirspeedIndicator;
@property (strong, nonatomic) IBOutlet UILabel *labelSliderEngineRPM;

@end
